/**************************************************************
Demo: Converting a DATA step program to DS2 with PROC DSTODS2
Section 1: Convert a DATA step to DS2 with PROC DSTODS2
Open and review the code in 1 - data step a.sas
**************************************************************/
proc dstods2 in ="&path/demos/1 - data step a.sas" 
             out="1 - data program a.sas"
             outdir="&path/demos/";
run;

/************************************************************** 
Finsh the DS2 program by hand:
a. Open 1 - data program a.sas and review the code produced. 
     Note that the output isn't complete or well formatted:
  1) PROC DS2, RUN, and QUIT statements were not generated.
  2) OTHER is enclosed in double quotations (reserved word).
  3) Unused label_return: ( conversion process artifact)
  4) All code is in the RUN() method.

b. Modify the program:
  1) Add a PROC DS2 statement at the top.
  2) Add RUN and QUIT statements at the end.
  3) Right-click the code window and choose "Format code". 
  4) Note that formatted code is  easier to read. 
  5) Delete the unused _return: label and null statements.
 
c. Test the DS2 program:
  1) Run the program and review the log. Note the undeclared variable warning. 

d. Modify the program again:
   Add the /overwrite=yes to the data statement
   Add global statement:
      DCL double benefits;  
 e. Re-sumbit the program. Note that the results produced are now the same 
    as those produced by the original DATA step.
**************************************************************/

/**************************************************************
Section 2: Convert a more complex DATA step to DS2

Open 1 - data step b.sas 
3.a. Review the code. Note that the DATA step reads in the 
     orion.banks data set. It contains contitonal processing
     for steps only executed during processing of the first 
     and last iterations of the program. Run the program. 
     Review the log and notice:
     **> Starting
     Text=**> Starting last=0 NAME=Carolina Bank and Trust RATE=0.0318 _ERROR_=0 _N_=1
     Text=  last=0 NAME=State Savings Bank RATE=0.0321 _ERROR_=0 _N_=2
     Text=  last=1 NAME=National Savings and Trust RATE=0.0328 _ERROR_=0 _N_=3
     **> All done!
**************************************************************/

/**************************************************************
3. b. Submit the following code:
**************************************************************/
proc dstods2 in ="&path/demos/1 - data step b.sas" 
             out="1 - data program b.sas"
             outdir="&path/demos/";
run;

/************************************************************** 
  1) Review the result: Open 1 - data program b.sas and review the 
     code. Note that the output isn't complete or well formatted.
     Also note that all the code is RUN, but sections are better 
   	  suited for INIT and TERM. Finally, END=LAST is commented out 
   	  (not supported in DS2). 
3.c Modify the program: 
    Add a PROC DS2 statement at the top.
    Delete the unused _return: label
    Add RUN and QUIT statements at the end.
    Right-click the code window and choose "Format code". 
    Run the program and review the log. Note no errors, but:
    - Undeclared variable last is uninitialized
	 - IF LAST block code never executes. 
	 - Additional mods required to produce the correct result. 
	 Make the following changes to the code:
   1) Change the IF _n_=1.0; statement to METHOD INIT();.
   2) Change the IF last THEN DO; statement to METHOD TERM();.
   3) Move the METHOD RUN(); statement so that it comes just before the SET statement.
   4) Move the last END; statement to just before method TERM();.
   5) Delete the END=LAST comment.  
   6) Save your modifications to program ds203d17b_ds2.sas.

3.d. Run the program 
3.e. Review the log. Note the results produced are the same as 
     those produced by the original DATA step. 
**************************************************************/
